<?php
# -- BEGIN LICENSE BLOCK ---------------------------------------
#
# This file is part of Dotclear 2.
#
# Copyright (c) 2003-2014 Olivier Meunier & Association Dotclear
# Licensed under the GPL version 2.0 license.
# See LICENSE file or
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# -- END LICENSE BLOCK -----------------------------------------

if (!defined('DC_CONTEXT_ADMIN')) { return; }
header('Content-type: text/javascript');
?>
(function($) {
	$.toolbarPopup = function toolbarPopup(url) {
		var popup_params = 'alwaysRaised=yes,dependent=yes,toolbar=yes,';
		popup_params += 'height=420,width=520,menubar=no,resizable=yes,scrollbars=yes,status=no';
		var popup_link = window.open(url,'dc_popup', popup_params);
	};

	$.stripBaseURL = function stripBaseURL(url) {
		if (dotclear.base_url != '') {
			var pos = url.indexOf(dotclear.base_url);
			if (pos == 0) {
				url = url.substr(dotclear.base_url.length);
			}
		}
		
		return url;
	};

	/* Retrieve editor name from URL */
	$.getEditorName = function getEditorName(url) {
		return url.replace(/.*editor=([^&]*)(&.*)?/,'$1');
	}
})(jQuery);

$(function() {
	/* By default ckeditor load related resources with a timestamp to avoid cache problem when upgrading itself
	 * load_plugin_file.php does not allow other param that file to load (pf param), so remove timestamp
	 */

	CKEDITOR.timestamp = '';
	CKEDITOR.config.skin = 'dotclear,'+dotclear.dcckeditor_plugin_url+'/js/ckeditor-skins/dotclear/';

<?php if (!empty($dcckeditor_cancollapse_button)):?>    
	CKEDITOR.config.toolbarCanCollapse = true;
<?php endif;?>
	
	CKEDITOR.plugins.addExternal('entrylink',dotclear.dcckeditor_plugin_url+'/js/ckeditor-plugins/entrylink/');	
	CKEDITOR.plugins.addExternal('dclink',dotclear.dcckeditor_plugin_url+'/js/ckeditor-plugins/dclink/');
	CKEDITOR.plugins.addExternal('media',dotclear.dcckeditor_plugin_url+'/js/ckeditor-plugins/media/');

	$('textarea#post_excerpt,textarea#post_content').ckeditor({
		extraPlugins: 'entrylink,dclink,media,justify,colorbutton,format',
        
		<?php if (!empty($dcckeditor_format_select)):?>				
		// format tags
		format_tags: 'h1;h2;h3;h4;h5;h6;pre;address',

		// following definition are needed to be specialized
		format_h1: { element: 'h1' },
		format_h2: { element: 'h2' },
		format_h3: { element: 'h3' },
		format_h4: { element: 'h4' },
		format_h5: { element: 'h5' },
		format_h6: { element: 'h6' },
		format_pre: { element: 'pre' },
		format_address: { element: 'address' },
		<?php endif;?>

		entities: false,
		allowedContent: true,
		toolbar: [
			{
				name: 'basicstyles',
				items: [
					<?php if (!empty($dcckeditor_format_select)):?>				
					'Format',
					<?php endif;?>
					'Bold','Italic','Underline','Strike','Subscript','Superscript','Code','Blockquote',
					
<?php if (!empty($dcckeditor_list_buttons)):?>
					'NumberedList', 'BulletedList',
<?php endif;?>
                    'RemoveFormat']
			},
<?php if (!empty($dcckeditor_alignment_buttons)):?>
			{
				name: 'paragraph',
				items: ['JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock']
			},
<?php endif;?>
			{
				name: 'custom',
				items: ['EntryLink','dcLink','Media','-',
					'Source', 'Maximize'
					<?php if (!empty($dcckeditor_textcolor_button)):?>,'TextColor'<?php endif;?>
				       ] 
			},
		]
	});

	CKEDITOR.on('instanceReady', function(e) {
		if ($('label[for="post_excerpt"] a img').attr('src')==dotclear.img_minus_src) {
			$('#cke_post_excerpt').removeClass('hide');
		} else {
			$('#cke_post_excerpt').addClass('hide');
		}
		
		$('#excerpt-area label').click(function() {
			$('#cke_post_excerpt').toggleClass('hide',$('#post_excerpt').hasClass('hide'));
		});
	});
});
